<?php
/**
 * The template for displaying car.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
global $NOVARIDE_STORAGE;
while ( have_posts() ) :
	the_post();

	$car_detail_page_layout	=	get_theme_mod( 'car_detail_page_layout', $NOVARIDE_STORAGE['car_detail_page_layout'] );
	$show_featured_image	=	get_theme_mod( 'show_featured_image', $NOVARIDE_STORAGE['show_featured_image'] );
	if($car_detail_page_layout == 'full-width') {
		$column = 'col-md-12';
	}
	else{
		$column = 'col-lg-8 col-md-12';
	}

	$secondary_image = get_post_meta(get_the_ID(), 'awaiken_secondary_image', true);
	if(empty($secondary_image)) {
		$background_image 	= get_theme_mod( 'car_detail_page_header_background_image', $NOVARIDE_STORAGE['car_detail_page_header_background_image'] );
		if($background_image) {
			$background_image 	= 	wp_get_attachment_image_src( $background_image , 'full' );
			if(isset($background_image[0])) {
				$secondary_image	=	$background_image[0];
			}
		}
		else{
			$background_image 	= get_theme_mod( 'header_background_image', $NOVARIDE_STORAGE['header_background_image'] );
			if($background_image) {
				$background_image 	= 	wp_get_attachment_image_src( $background_image , 'full' );
				if(isset($background_image[0])) {
					$secondary_image	=	$background_image[0];
				}
			}
		}
	}

?>
<main id="content" <?php post_class( 'site-main' ); ?>>
	<div class="page-header background-section" <?php if($secondary_image) { ?> style="background-image: url('<?php echo esc_url($secondary_image); ?>')" <?php } ?>>
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-12">
					<div class="page-header-box">
						<?php the_title( '<h1 class="at-animation-heading-style-3">', '</h1>' ); ?>
						<?php do_action('novaride_action_get_breadcrumb'); ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="page-fleets-single">
		<div class="container">
			<div class="row">
				<?php 
					if($car_detail_page_layout == 'with-sidebar'):
						get_sidebar('car');
					endif;
				?>
			
				<div class="<?php echo esc_attr( $column ); ?>">
                    <div class="fleets-single-content">
					<?php					
						if ( $show_featured_image && has_post_thumbnail() ) {
							printf( '<div class="post-single-image"><figure class="image-anime">%s</figure></div>', get_the_post_thumbnail( $post, 'large' ) );
						}
					?>
						<?php
							the_content();
						?>
					</div>
					<?php 
						if ( comments_open() || get_comments_number() ) :
						echo '<div class="comment-box">';
							comments_template();
						echo '</div>';
						endif;
					?>
				</div>
				
			</div>
		</div>
	</div>
</main>
<?php
endwhile;
