<?php
/**
 * The template for displaying cars.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
global $NOVARIDE_STORAGE;
$car_list_page_layout	=	get_theme_mod( 'car_list_page_layout', $NOVARIDE_STORAGE['car_list_page_layout'] );
if($car_list_page_layout == 'full-width') {
	$column = 'col-md-12';
}
else{
	$column = 'col-lg-9 col-md-12';
}

$background_image 	= get_theme_mod( 'car_list_page_header_background_image', $NOVARIDE_STORAGE['car_list_page_header_background_image'] );
if($background_image) {
	$background_image 	= 	wp_get_attachment_image_src( $background_image , 'full' );
	if(isset($background_image[0])) {
		$background_image	=	$background_image[0];
	}
}

?>
<main id="content" class="site-main">
	<div class="page-header background-section" <?php if($background_image) { ?> style="background-image: url('<?php echo esc_url($background_image); ?>')" <?php } ?>>
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-12">
					<div class="page-header-box">
						<h1 class="entry-title"><?php 
									$novaride_blog_title_text = novaride_get_archive_title();
									echo wp_kses_data( $novaride_blog_title_text ); ?></h1>
								<?php
									the_archive_description( '<div class="taxonomy-description">', '</div>' );
								?>
						<?php do_action('novaride_action_get_breadcrumb'); ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="page-content">
		<div class="page-fleets">
			<div class="container">
				<div class="row">
					<?php 
						if($car_list_page_layout == 'with-sidebar'):
							get_sidebar('car-list');
						endif;
					?>
					<div class="<?php echo esc_attr( $column ); ?>">
						<div class="row">
					<?php
					while ( have_posts() ) {
						the_post();
						$post_link = get_permalink();
						$car_type 	=	wp_get_post_terms( get_the_ID(), 'car-types' );
						?>

						<div class="col-lg-4 col-md-6">
							<div class="perfect-fleet-item fleets-collection-item">
                                    <?php
										if ( has_post_thumbnail() ) {
											printf( '<div class="image-box"><a href="%s">%s</a></div>', esc_url( $post_link ), get_the_post_thumbnail( $post, 'novaride-thumb' ) );
										}
									?>
    
                                    <div class="perfect-fleet-content">
										<div class="perfect-fleet-title">
											<?php 
												if($car_type) {  
												foreach ( $car_type as $cat ) {
													?>
													<h3><a href="<?php echo esc_url(get_term_link( $cat )) ?>"><?php echo esc_html( $cat->name );  ?></a></h3>
													<?php 
													break;
												}
												}
											?>
											<?php
												printf( '<h2><a href="%s">%s</a></h2>', esc_url( $post_link ), wp_kses_post( get_the_title() ) );
											?>
                                        </div>
                                        
                                        <div class="perfect-fleet-body">
                                          <?php echo novaride_display_car_features( 2 ); ?>
                                        </div>
    
                                        <div class="perfect-fleet-footer">
                                            <div class="perfect-fleet-pricing">
                                               <?php echo novaride_display_car_price(); ?>
                                            </div>
                                            <div class="perfect-fleet-btn">
                                                <a href="<?php echo esc_url( $post_link ); ?>" class="section-icon-btn"><img src="<?php echo esc_url($NOVARIDE_STORAGE['arrow_white']); ?>" alt=""></a>
                                            </div>
                                        </div>
                                    </div>
							</div>
                          </div>
						<?php } ?>
							<div class="col-md-12">
								<?php
									echo get_the_posts_pagination( array(
											'mid_size' => 2,
											'prev_text' => '<i class="fa-solid fa-arrow-left-long"></i>',
											'next_text' => '<i class="fa-solid fa-arrow-right-long"></i>',
										) );
								?>
							</div>
						</div>
					</div>
					
				</div>
			</div>
		</div>
	</div>
</main>
