<?php
/**
 * The site's entry point.
 *
 * Loads the relevant template part,
 * the loop is executed (when needed) by the relevant template part.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$is_car_archive = false;
if(isset($_GET['post_types']) && $_GET['post_types'] == 'cars') {
	$is_car_archive = true;	
}


get_header();

if ( is_page() ) {
	get_template_part( 'template-parts/page' );
} elseif ( is_singular('cars') ) {
	get_template_part( 'template-parts/single-car' );
} elseif ( is_singular() ) {
	get_template_part( 'template-parts/single' );
} elseif ( is_post_type_archive('cars') || is_tax('car-types') || $is_car_archive ) {
	get_template_part( 'template-parts/archive-cars' );
} elseif ( is_archive() || is_home() ) {
	get_template_part( 'template-parts/archive' );
} elseif ( is_search() ) {
	get_template_part( 'template-parts/search' );
} else {
	get_template_part( 'template-parts/404' );
}

get_footer();