<?php 
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
* Set our Customizer default options
*/
if ( ! function_exists( 'awaiken_generate_defaults' ) ) {
	function awaiken_generate_defaults() {
		global $NOVARIDE_STORAGE;

		return apply_filters( 'awaiken_customizer_defaults', $NOVARIDE_STORAGE );
	}
}


/**
 * Customizer Setup and Custom Controls
 *
 */

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class awaiken_initialise_customizer_settings {
	// Get our default values
	private $defaults;

	public function __construct() {
		// Get our Customizer defaults
		$this->defaults = awaiken_generate_defaults();


		// Register sections
		add_action( 'customize_register', array( $this, 'awaiken_add_customizer_sections' ) );
		
		// Register general control
		add_action( 'customize_register', array( $this, 'awaiken_register_general_options_controls' ) );
		
		// Register car detail page control
		add_action( 'customize_register', array( $this, 'awaiken_register_car_detail_page_options_controls' ) );

		// Register blog control
		add_action( 'customize_register', array( $this, 'awaiken_register_blog_options_controls' ) );
		
		// Register footer control
		add_action( 'customize_register', array( $this, 'awaiken_register_footer_options_controls' ) );
		
	}


	/**
	 * Register the Customizer sections
	 */
	public function awaiken_add_customizer_sections( $wp_customize ) {
		
		// Add section general options
		$wp_customize->add_section( 'general_options' , array(
			'title'      => __( 'General Options', 'novaride' ),
		) );
		
		// Add section car list page options
		$wp_customize->add_section( 'car_list_page_options' , array(
			'title'      => __( 'Car List Page Options', 'novaride' ),
			'panel' => 'car_options'
		) );
		
		// Add section car detail page options
		$wp_customize->add_section( 'car_detail_options' , array(
			'title'      => __( 'Car Detail Page Options', 'novaride' ),
			'panel' => 'car_options'
		) );
		
		// Add section blog options
		$wp_customize->add_section( 'blog_options' , array(
			'title'      => __( 'Blog Options', 'novaride' ),
		) );
		
		// Add section footer options
		$wp_customize->add_section( 'footer_options' , array(
			'title'      => __( 'Footer Options', 'novaride' ),
		) );
		
	}
	
	/**
	 * Register general option controls
	 */

	public function awaiken_register_general_options_controls( $wp_customize ) {  
		
		$section	=	'general_options';
		
		// Preloader
		$wp_customize->add_setting( 'show_preloader',
			array(
				'default' => $this->defaults['show_preloader'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_preloader',
			array(
				'label' => __( 'Preloader', 'novaride' ),
				'description' => esc_html__( 'Display preloader while the page is loading.', 'novaride' ),
				'section' => $section
			)
		) );
		
		// Tag line
		$wp_customize->add_setting( 'show_tagline_after_logo',
			array(
				'default' => $this->defaults['show_tagline_after_logo'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_tagline_after_logo',
			array(
				'label' => __( 'Tagline', 'novaride' ),
				'description' => esc_html__( 'Display Tagline after logo.', 'novaride' ),
				'section' => $section
			)
		) );
		
		// Magic Cursor
		$wp_customize->add_setting( 'magic_cursor',
			array(
				'default' => $this->defaults['magic_cursor'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'magic_cursor',
			array(
				'label' => __( 'Magic Cursor', 'novaride' ),
				'description' => esc_html__( 'Show Magic Cursor.', 'novaride' ),
				'section' => $section
			)
		) );
		
		
		// Smooth scrolling
		$wp_customize->add_setting( 'smooth_scrolling',
			array(
				'default' => $this->defaults['smooth_scrolling'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'smooth_scrolling',
			array(
				'label' => __( 'Smooth Scrolling', 'novaride' ),
				'description' => esc_html__( 'Smooth Scrolling Disable/Enable', 'novaride' ),
				'section' => $section
			)
		) );
		
		// heading icon 
		$wp_customize->add_setting( 'show_small_heading_icon',
			array(
				'default' => $this->defaults['show_small_heading_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_small_heading_icon',
			array(
				'label' => __( 'Display Small Icon', 'novaride' ),
				'description' => esc_html__( 'Display small icon before small heading.', 'novaride' ),
				'section' => $section
			)
		) );
		
		// heading icon
		$wp_customize->add_setting( 'small_heading_icon',
			array(
				'default' => $this->defaults['small_heading_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'small_heading_icon',
			array(
				'label' => __( 'Small heading icon', 'novaride' ),
				'description' => esc_html__( 'If you want to change the current icon, select it here.', 'novaride' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'novaride' ),
					'change' => __( 'Change File', 'novaride' ),
					'default' => __( 'Default', 'novaride' ),
					'remove' => __( 'Remove', 'novaride' ),
					'placeholder' => __( 'No file selected', 'novaride' ),
					'frame_title' => __( 'Select File', 'novaride' ),
					'frame_button' => __( 'Choose File', 'novaride' ),
				)
			)
		) );
		
		// Preloader icon
		$wp_customize->add_setting( 'preloader_icon',
			array(
				'default' => $this->defaults['preloader_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'preloader_icon',
			array(
				'label' => __( 'Preloader icon', 'novaride' ),
				'description' => esc_html__( 'If you want to change the current loading icon, select it here.', 'novaride' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'novaride' ),
					'change' => __( 'Change File', 'novaride' ),
					'default' => __( 'Default', 'novaride' ),
					'remove' => __( 'Remove', 'novaride' ),
					'placeholder' => __( 'No file selected', 'novaride' ),
					'frame_title' => __( 'Select File', 'novaride' ),
					'frame_button' => __( 'Choose File', 'novaride' ),
				)
			)
		) );
		
		// Header background image
		$wp_customize->add_setting( 'header_background_image',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'header_background_image',
			array(
				'label' => __( 'Header Background Image', 'novaride' ),
				'description' => esc_html__( 'Header background image is intended for pages that are not created using Elementor.', 'novaride' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'novaride' ),
					'change' => __( 'Change File', 'novaride' ),
					'default' => __( 'Default', 'novaride' ),
					'remove' => __( 'Remove', 'novaride' ),
					'placeholder' => __( 'No file selected', 'novaride' ),
					'frame_title' => __( 'Select File', 'novaride' ),
					'frame_button' => __( 'Choose File', 'novaride' ),
				)
			)
		) );

	}
	
	/**
	 * Register car option controls
	 */
	
	public function awaiken_register_car_detail_page_options_controls( $wp_customize ) { 
			
		$section	=	'car_detail_options';
		
		

		// car page title 
		$wp_customize->add_setting( 'car_page_title', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'car_page_title', array(
			'type' => 'text',
			'section' => 'car_list_page_options',
			'label'       => esc_html__( 'Car List Page Title', 'novaride' ),
		) );
		
		// Header background image
		$wp_customize->add_setting( 'car_list_page_header_background_image',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'car_list_page_header_background_image',
			array(
				'label' => __( 'Header Background Image', 'novaride' ),
				'description' => esc_html__( 'Header background image for car list page that are run using the default page template.', 'novaride' ),
				'section' => 'car_list_page_options',
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'novaride' ),
					'change' => __( 'Change File', 'novaride' ),
					'default' => __( 'Default', 'novaride' ),
					'remove' => __( 'Remove', 'novaride' ),
					'placeholder' => __( 'No file selected', 'novaride' ),
					'frame_title' => __( 'Select File', 'novaride' ),
					'frame_button' => __( 'Choose File', 'novaride' ),
				)
			)
		) );
		
		// List page layout
		$wp_customize->add_setting( 'car_list_page_layout', array(
		  'default' => $this->defaults['car_list_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'car_list_page_layout', array(
			  'label'          => __( 'Car List Page Layout', 'novaride' ),
			  'section' => 'car_list_page_options',
			  'settings' => 'car_list_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'novaride' ),
				'with-sidebar'  => __( 'With Sidebar', 'novaride' )
			  ),
		) );
		
		// detail page layout
		
	
		$wp_customize->add_setting( 'car_detail_page_layout', array(
		  'default' => $this->defaults['car_detail_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'car_detail_page_layout', array(
			  'label'          => __( 'Car Detail Page Layout', 'novaride' ),
			  'section' => $section,
			  'settings' => 'car_detail_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'novaride' ),
				'with-sidebar'  => __( 'With Sidebar', 'novaride' )
			  ),
		) );
		
		// Header background image for detail
		$wp_customize->add_setting( 'car_detail_page_header_background_image',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'car_detail_page_header_background_image',
			array(
				'label' => __( 'Header Background Image', 'novaride' ),
				'description' => esc_html__( 'Header background image for car detail page that are run using the default page template.', 'novaride' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'novaride' ),
					'change' => __( 'Change File', 'novaride' ),
					'default' => __( 'Default', 'novaride' ),
					'remove' => __( 'Remove', 'novaride' ),
					'placeholder' => __( 'No file selected', 'novaride' ),
					'frame_title' => __( 'Select File', 'novaride' ),
					'frame_button' => __( 'Choose File', 'novaride' ),
				)
			)
		) );
		
		// Featured Image
		$wp_customize->add_setting( 'show_featured_image',
			array(
				'default' => $this->defaults['show_featured_image'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_featured_image',
			array(
				'label' => __( 'Featured Image', 'novaride' ),
				'description' => esc_html__( 'Show or hide the Featured Image.', 'novaride' ),
				'section' => $section
			)
		) );
		
	
		// show whatsapp button
		$wp_customize->add_setting( 'show_whatsapp_button',
			array(
				'default' => $this->defaults['show_whatsapp_button'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_whatsapp_button',
			array(
				'label' => __( 'WhatsApp Button', 'novaride' ),
				'description' => esc_html__( 'Show or hide the WhatsApp Button.', 'novaride' ),
				'section' => $section
			)
		) );
		
		// Whatsapp Number
		$wp_customize->add_setting( 'novaride_whatsapp_number', array(
			'default' => $this->defaults['novaride_whatsapp_number'],
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'novaride_whatsapp_number', array(
			'type' => 'text',
			'section' =>  $section,
			'label'       => esc_html__( 'Whatsapp Number', 'novaride' ),
		) );
		
		// Booking form
		$wp_customize->add_setting( 'novaride_booking_form_popup_id', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'novaride_booking_form_popup_id', array(
			'type' => 'text',
			'section' => $section,
			'description' => esc_html__( 'Add the Saved Template ID here from Templates > Saved Templates, and ensure the template contains only one Popup Modal widget.', 'novaride' ),
			'label'       => esc_html__( 'Booking Form Popup ID', 'novaride' ),
		) );
		
	}
	
	/**
	 * Register blog option controls
	 */
	
	public function awaiken_register_blog_options_controls( $wp_customize ) { 
			
		$section	=	'blog_options';

		// Blog page title 
		$wp_customize->add_setting( 'blog_page_title', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'blog_page_title', array(
			'type' => 'text',
			'section' => $section,
			'label'       => esc_html__( 'Blog Page Title', 'novaride' ),
		) );
		
		//Header Background Image
		$wp_customize->add_setting( 'blog_page_header_background_image',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'blog_page_header_background_image',
			array(
				'label' => __( 'Header Background Image', 'novaride' ),
				'description' => esc_html__( 'Header background image for blog archive and single page.', 'novaride' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'novaride' ),
					'change' => __( 'Change File', 'novaride' ),
					'default' => __( 'Default', 'novaride' ),
					'remove' => __( 'Remove', 'novaride' ),
					'placeholder' => __( 'No file selected', 'novaride' ),
					'frame_title' => __( 'Select File', 'novaride' ),
					'frame_button' => __( 'Choose File', 'novaride' ),
				)
			)
		) );
		
		// Archive page layout
		$wp_customize->add_setting( 'archive_page_layout', array(
		  'default' => $this->defaults['archive_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'archive_page_layout', array(
			  'label'          => __( 'Archive Page Layout', 'novaride' ),
			  'section' => $section,
			  'settings' => 'archive_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'novaride' ),
				'with-sidebar'  => __( 'With Sidebar', 'novaride' )
			  ),
		) );
		
		// Archive page single page layout
		$wp_customize->add_setting( 'blog_single_page_layout', array(
		  'default' => $this->defaults['blog_single_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'blog_single_page_layout', array(
			  'label'          => __( 'Blog Single Layout', 'novaride' ),
			  'section' => $section,
			  'settings' => 'blog_single_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'novaride' ),
				'with-sidebar'  => __( 'With Sidebar', 'novaride' )
			  ),
		) );
		
		// Social Sharing
		$wp_customize->add_setting( 'social_sharing',
			array(
				'default' => $this->defaults['social_sharing'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_text_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Pill_Checkbox_Custom_Control( $wp_customize, 'social_sharing',
			array(
				'label' => __( 'Social Sharing', 'novaride' ),
				'description' => esc_html__( 'Choose the social network you want to display in the social share box.', 'novaride' ),
				'section' => $section,
				'input_attrs' => array(
					'sortable' => true,
					'fullwidth' => true,
				),
				'choices' => array(
					'facebook' => esc_attr__( 'Facebook', 'novaride' ),
					'twitter' => esc_attr__( 'Twitter', 'novaride' ),
					'whatsapp' => esc_attr__( 'Whatsapp', 'novaride' ),
					'linkedin' => esc_attr__( 'LinkedIn', 'novaride' ),
					'reddit' => esc_attr__( 'Reddit', 'novaride' ),
					'tumblr' => esc_attr__( 'Tumblr', 'novaride' ),
					'pinterest' => esc_attr__( 'Pinterest', 'novaride' ),
					'vk' => esc_attr__( 'vk', 'novaride' ),
					'email' => esc_attr__( 'Email', 'novaride' ),
					'telegram' => esc_attr__( 'Telegram', 'novaride' ),
				)
			)
		) );

	}
	
	/**
	 * Register footer controls
	 */
	
	public function awaiken_register_footer_options_controls( $wp_customize ) { 
		
		$section	=	'footer_options';
		
		//Footer logo
		$wp_customize->add_setting( 'footer_logo',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'footer_logo',
			array(
				'label' => __( 'Footer Logo', 'novaride' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'novaride' ),
					'change' => __( 'Change File', 'novaride' ),
					'default' => __( 'Default', 'novaride' ),
					'remove' => __( 'Remove', 'novaride' ),
					'placeholder' => __( 'No file selected', 'novaride' ),
					'frame_title' => __( 'Select File', 'novaride' ),
					'frame_button' => __( 'Choose File', 'novaride' ),
				)
			)
		) );
		
		// Copyright text
		$wp_customize->add_setting( 'footer_copyright_text',
			array(
				'default' => $this->defaults['footer_copyright_text'],
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_kses_post'
			)
		);
		$wp_customize->add_control( 'footer_copyright_text',
			array(
				'label' => __( 'Copyright Text', 'novaride' ),
				'section' => $section,
				'type' => 'textarea',
			)
		);
		
		// Social media URLs
		$wp_customize->add_setting( 'social_urls',
			array(
				'default' => $this->defaults['social_urls'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_url_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Sortable_Repeater_Custom_Control( $wp_customize, 'social_urls',
			array(
				'label' => __( 'Social URLs', 'novaride' ),
				'description' => esc_html__( 'Enter the social profile URLs.', 'novaride' ),
				'section' => $section,
				'button_labels' => array(
					'add' => __( 'Add Row', 'novaride' ),
				)
			)
		) );
		
	}
	
}

/**
 * Load all our Customizer Custom Controls
 */
require_once NOVARIDE_THEME_DIR . '/inc/customizer/custom-controls.php';

/**
 * Initialise our Customizer settings
 */
$awaiken_settings = new awaiken_initialise_customizer_settings();
