<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

defined( 'ABSPATH' ) || die();

class novaride_widget_car_slider extends Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		parent::__construct( $data, $args );
	}

	public function get_name() {
		return 'novaride-car-slider';
	}

	public function get_title() {
		return __( 'Novaride - Car Slider', 'novaride' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return array( 'general' );
	}
	
	public function get_keywords() {
		return [ 'novaride', 'car', 'slider'];
	}

	protected function register_controls() {
		
		// Section: General ----------
		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__( 'General', 'novaride' ),
			]
		);
		
		$this->add_control(
			'slider_data_type',
			[
				'label' => esc_html__( 'Cars', 'novaride' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest' => esc_html__( 'Latest Cars', 'novaride' ),
					'selected' => esc_html__( 'Selected Cars', 'novaride' ),
				]
			]
		);
		
		$this->add_control(
			'numbers_of_cars_to_show',
			[
				'label' => esc_html__( 'Numbers of cars to show', 'novaride' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 7,
				'condition' => [
					'slider_data_type' => 'latest',
				],
			]
		);

		
		$args = [
			'post_type' => 'cars',
			'post_status' => 'publish',
			'posts_per_page' => -1
		];
		
		if ( isset( $request['s'] ) ) {
			$args['s'] = $request['s'];
		}

		$options = [];
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
			
				$options[get_the_ID()] = html_entity_decode(get_the_title());
			}
		}
		wp_reset_postdata();
		
		$this->add_control(
			'selected_cars',
			array(
				'label' => esc_html__( 'Select Cars', 'novaride' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => $options,
				'condition' => [
					'slider_data_type' => 'selected',
				],
			)
		);

		$this->end_controls_section(); // End Controls Section

	}
		
	protected function render( ) {
		global $NOVARIDE_STORAGE;
		// Get Settings
		$slider_data_type 			= $this->get_settings( 'slider_data_type' );
		$numbers_of_cars_to_show 	= $this->get_settings( 'numbers_of_cars_to_show' );
		
		if ( $slider_data_type  === 'latest' ) {
			
			$args = [
					'post_type' => 'cars',
					'post_status' => 'publish',
					'posts_per_page' => $this->get_settings( 'numbers_of_cars_to_show' )
				];
	
				
		}
		else{
			$selected_cars 			= $this->get_settings( 'selected_cars' );
			$args = [
					'post_type' => 'cars',
					'post_status' => 'publish',
					'post__in' => $selected_cars
				];
		}
			
		// Config
		$config = array(
			'rtl'            => is_rtl(),
			'arrows'         => true,
			'dots'           => false,
			'pauseOnHover'   => true,
			'autoplay'       => true,
			'speed'          => 1000,
			'slidesPerGroup' => 1,
			'slidesPerView'  => 1,
			'loop'           => true,
			'spaceBetween'   => 30,
			'breakpoints'    => array(
				320  => array(
					'slidesPerView'  => 1,
				),
				768  => array(
					'slidesPerView'  => 2,
				),
				991  => array(
					'slidesPerView'  => 3,
				),
				1300  => array(
					'slidesPerView'  => 4,
				),
				1600 => array(
					'slidesPerView'  => 5,
				),
			),

		);

		// HTML Attribute
		$this->add_render_attribute(
			'wrapper',
			array(
				'data-config' => wp_json_encode( $config ),
			)
		);

		// Swiper container
		$this->add_render_attribute(
			'swiper-container',
			array(
				'class' => 'novaride-main-swiper swiper',
			)
		);
		?>
		<div class="novaride-car-slider arrow_inside" <?php $this->print_render_attribute_string( 'wrapper' ); ?>>
			<div <?php $this->print_render_attribute_string( 'swiper-container' ); ?>>
					<div class="swiper-wrapper">
						<?php
						
								
								$options = [];
							$query = new WP_Query( $args );

							if ( $query->have_posts() ) {
								while ( $query->have_posts() ) {
									$query->the_post();
									$post_link = get_permalink();
									$car_type 	=	wp_get_post_terms( get_the_ID(), 'car-types' );
									//$options[get_the_ID()] = html_entity_decode(get_the_title());
									?>
									<div class="swiper-slide">
										<div class="perfect-fleet-item">
											<?php
												if ( has_post_thumbnail() ) {
													printf( '<div class="image-box"><a href="%s">%s</a></div>', esc_url( $post_link ), get_the_post_thumbnail(get_the_ID(), 'novaride-thumb' ) );
												}
											?>
			
											<div class="perfect-fleet-content">
												<div class="perfect-fleet-title">
													<?php 
														if($car_type) {  
														foreach ( $car_type as $cat ) {
															?>
															<h3><a href="<?php echo esc_url(get_term_link( $cat )) ?>"><?php echo esc_html( $cat->name );  ?></a></h3>
															<?php 
															break;
														}
														}
													?>
													<?php
														printf( '<h2><a href="%s">%s</a></h2>', esc_url( $post_link ), wp_kses_post( get_the_title() ) );
													?>
												</div>
												
												<div class="perfect-fleet-body">
												  <?php echo novaride_display_car_features( 2 ); ?>
												</div>
			
												<div class="perfect-fleet-footer">
													<div class="perfect-fleet-pricing">
													   <?php echo novaride_display_car_price(); ?>
													</div>
													<div class="perfect-fleet-btn">
														<a href="<?php echo esc_url( $post_link ); ?>" class="section-icon-btn"><img src="<?php echo esc_url($NOVARIDE_STORAGE['arrow_white']); ?>" alt=""></a>
													</div>
												</div>
											</div>
									</div>                              
									</div>
									<?php 
								}
							}
							wp_reset_postdata();
					?>
				</div>
				<div class="car-slider-btn">
					<div class="swiper-navigation-button swiper-button-prev ata-swiper-button-prev"></div>
					<div class="swiper-navigation-button swiper-button-next ata-swiper-button-next"></div>
				</div>
			</div>
		</div>
		<?php
		
	}
}
