<?php
/**
 * Theme functions and definitions
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'NOVARIDE_THEME_VERSION', wp_get_theme()->get( 'Version' ) );
define( 'NOVARIDE_THEME_DIR', get_template_directory() );
define( 'NOVARIDE_THEME_URL', get_template_directory_uri() );

if ( ! isset( $content_width ) ) {
	$content_width = 800; // Pixels.
}

// Theme storage
// Attention! Must be in the global namespace to compatibility with WP-CLI
//-------------------------------------------------------------------------
$GLOBALS['NOVARIDE_STORAGE'] = array(
		'social_sharing' => 'facebook,whatsapp,linkedin',
		'social_urls' => 'https://www.instagram.com/ ,https://www.facebook.com/ ,https://www.youtube.com/',
		'arrow_white' => NOVARIDE_THEME_URL.'/assets/images/arrow-white.svg',
		'show_preloader' => 0,
		'show_tagline_after_logo' => 0,
		'magic_cursor' => 1,
		'show_small_heading_icon' => 1,
		'small_heading_icon' => '',
		'footer_copyright_text' => '',
		'smooth_scrolling' => 0,
		'archive_page_layout' => 'full-width',
		'blog_single_page_layout' => 'full-width',
		'preloader_icon' => '',
		'novaride_currency' => '$',
		'novaride_per_day_text' => 'Per Day' ,
		'novaride_per_hour_text' => 'Per Hour',
		'car_page_title' => '',
		'car_list_page_layout' => 'with-sidebar',
		'header_background_image' => '',
		'car_list_page_header_background_image' => '',
		'novaride_whatsapp_number' => '',
		'car_detail_page_layout' => 'with-sidebar',
		'car_detail_page_header_background_image' => '',
		'show_featured_image' => 0,
		'show_whatsapp_button' => 1,
		'blog_page_header_background_image' => '',
);

if ( ! function_exists( 'novaride_slug_fonts_url' ) ) {
	function novaride_slug_fonts_url() {
		$fonts_url = ''; 
		  
		/* Translators: If there are characters in your language that are not
		* supported by Epilogue, translate this to 'off'. Do not translate
		* into your own language.
		*/
		$font = _x( 'on', 'Epilogue font: on or off', 'novaride' );
		
		/* Translators: If there are characters in your language that are not
		* supported by DM Sans, translate this to 'off'. Do not translate
		* into your own language.
		*/
		$font2 = _x( 'on', 'DM Sans font: on or off', 'novaride' );
		 
		if ( 'off' !== $font || 'off' !== $font2 ) {
			
			$font_families = array();
			 
			if ( 'off' !== $font ) {
				$font_families[] = 'Epilogue:ital,wght@0,100..900;1,100..900';
			}
			
			if ( 'off' !== $font2 ) {
				$font_families[] = 'DM Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000';
			}
			 
			$query_args = array(
				'family'	=> urlencode( implode( '&family=', $font_families ) ),
				'display' 	=> urlencode( 'swap' ),
			);
		
			$query_args = str_replace(array('%26','%3D'), array('&','='), $query_args);
			
			$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css2' );
			
		}
		 
		return esc_url_raw( $fonts_url );
	}
}

if ( ! function_exists( 'novaride_theme_setup' ) ) {
	/**
	 * Set up theme support.
	 *
	 * @return void
	 */
	function novaride_theme_setup() {
	
		register_nav_menus( 
			array( 
					'header' => esc_html__( 'Header', 'novaride' ) ,
					'footer' => esc_html__( 'Footer', 'novaride' ) 
				 )		
		);

		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'editor-styles' );
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			)
		);
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 100,
				'width'       => 350,
				'flex-height' => true,
				'flex-width'  => true,
			)
		);
		
		/*
		 * Gutenberg wide images.
		 */
		add_theme_support( 'align-wide' );
		
		/**
        * Load textdomain.
        */
        load_theme_textdomain( 'novaride', NOVARIDE_THEME_DIR . '/languages' );

		add_image_size( 'novaride-thumb', 410, 240 );
		
		 // Disable block-based widget support
        remove_theme_support( 'widgets-block-editor' );
		
		if ( is_admin() ) { 
			
			$active_demo = novaride_get_active_demo();
			if( $active_demo == 1 ) {
				add_editor_style( array( novaride_slug_fonts_url(), 'assets/css/css-variable.css', 'assets/css/all.min.css', 'style-editor.css' ) );
			}
			else if(  $active_demo == 2 ) {
				add_editor_style( array( novaride_slug_fonts_url(), 'assets/css/css-variable-dark.css', 'assets/css/all.min.css', 'assets/css/style-editor-dark.css' ) );
			}
		}
	
	}

}
add_action( 'after_setup_theme', 'novaride_theme_setup' );

/**
 * Enqueue styles
 */
if ( ! function_exists( 'novaride_theme_load_styles' ) ) {
	function novaride_theme_load_styles() {
		
		if( get_option( 'novaride_demo_imported' ) != 1 ) {
			wp_enqueue_style( 'novaride-font-manrope', novaride_slug_fonts_url(), array(), null );	
		}
		
		$active_demo = novaride_get_active_demo();
		if( $active_demo == 1 ) {
			wp_enqueue_style( 'novaride-css-variable', NOVARIDE_THEME_URL . '/assets/css/css-variable.css', array(), NOVARIDE_THEME_VERSION );
		}
		else if(  $active_demo == 2 ) {
			wp_enqueue_style( 'novaride-css-variable', NOVARIDE_THEME_URL . '/assets/css/css-variable-dark.css', array(), NOVARIDE_THEME_VERSION );
		}
		
		wp_enqueue_style('e-swiper');
		wp_enqueue_style( 'fontawesome-6.4.0', NOVARIDE_THEME_URL . '/assets/css/all.min.css', array(), NOVARIDE_THEME_VERSION );
		wp_enqueue_style( 'bootstrap-5.3.2', NOVARIDE_THEME_URL . '/assets/css/bootstrap.min.css', array(), NOVARIDE_THEME_VERSION );
		wp_enqueue_style( 'novaride-style', NOVARIDE_THEME_URL . '/style.css', array('bootstrap-5.3.2','fontawesome-6.4.0'), NOVARIDE_THEME_VERSION );
		
	}
}
add_action( 'wp_enqueue_scripts', 'novaride_theme_load_styles',999 );

/**
 * Enqueue scripts
 */
if ( ! function_exists( 'novaride_theme_load_scripts' ) ) {
	function novaride_theme_load_scripts() {
		global $NOVARIDE_STORAGE;
	
		if( get_theme_mod( 'smooth_scrolling', $NOVARIDE_STORAGE['smooth_scrolling'] ) ) { 
			wp_enqueue_script( 'SmoothScroll', NOVARIDE_THEME_URL . '/assets/js/SmoothScroll.js', array( 'jquery' ), NOVARIDE_THEME_VERSION, true );
		}
		
		wp_enqueue_script( 'gsap', NOVARIDE_THEME_URL . '/assets/js/gsap.min.js', array( 'jquery' ), NOVARIDE_THEME_VERSION, true );
		if( get_theme_mod( 'magic_cursor', $NOVARIDE_STORAGE['magic_cursor'] ) ) { 
		wp_enqueue_script( 'magiccursor', NOVARIDE_THEME_URL . '/assets/js/magiccursor.js', array( 'jquery' ), NOVARIDE_THEME_VERSION, true );
		}
		
		wp_enqueue_script( 'SplitText', NOVARIDE_THEME_URL . '/assets/js/SplitText.js', array( 'jquery' ), NOVARIDE_THEME_VERSION, true );
		wp_enqueue_script( 'ScrollTrigger', NOVARIDE_THEME_URL . '/assets/js/ScrollTrigger.min.js', array( 'jquery' ), NOVARIDE_THEME_VERSION, true );
		
		
		wp_enqueue_script( 'theme-js', NOVARIDE_THEME_URL . '/assets/js/function.js', array( 'jquery' ), NOVARIDE_THEME_VERSION, true );
		
		// js for comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

	}
}
add_action( 'wp_enqueue_scripts', 'novaride_theme_load_scripts' );


/**
 * Register widget area.
 */
if ( ! function_exists( 'novaride_widgets_init' ) ) {
	function novaride_widgets_init() {
		
		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar', 'novaride' ),
			'id'            => 'main-sidebar',
			'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'novaride' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Car List sidebar', 'novaride' ),
			'id'            => 'car-list-sidebar',
			'description'   => esc_html__( 'Add widgets here to appear in your car list sidebar.', 'novaride' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Car Detail sidebar', 'novaride' ),
			'id'            => 'car-detail-sidebar',
			'description'   => esc_html__( 'Add widgets here to appear in your car detail sidebar.', 'novaride' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
		
	}
}
add_action( 'widgets_init', 'novaride_widgets_init' );

/**
*	Include required file
*/
require_once NOVARIDE_THEME_DIR . '/inc/init.php';