<?php
/**
 * Repeatable Custom Fields in a Metabox
 * Author: Helen Hou-Sandi
 *
 */
 
function novaride_car_features_options() {
	
	$car_features = get_theme_mod( 'car_features', '' );
	$options	=	array();
	$option_placeholder = __('Select Features', 'novaride-themes-addons');
	$options[$option_placeholder] =  '';
	if($car_features) {
	$car_features = json_decode($car_features);
      foreach($car_features as $repeater_item) {
          $title		=	$repeater_item->title;
		  if($title) {
			$options[$title] = $title;
		  }
      }
	}

	return $options;
}

add_action('admin_init', 'novaride_add_meta_boxes', 1);
function novaride_add_meta_boxes() {
	add_meta_box( 'repeatable-fields',  __('Car Options', 'novaride-themes-addons'), 'novaride_meta_box_display', 'cars', 'normal', 'default');
}

function novaride_meta_box_display() {
	global $post;

	$novaride_car_features 	= get_post_meta( $post->ID, 'novaride_car_features', true );
	$novaride_car_price		= get_post_meta( $post->ID, 'novaride_car_price', true );
	$price_type				= get_post_meta( $post->ID, 'novaride_car_price_type', true );
	$novaride_currency		= get_theme_mod( 'novaride_currency', '$'  );

	$options = novaride_car_features_options();

	wp_nonce_field( 'novaride_meta_box_nonce', 'novaride_meta_box_nonce' );
	?>
	<script type="text/javascript">
	jQuery(document).ready(function( $ ){
		$( '#add-row' ).on('click', function() {
			var row = $( '.empty-row.screen-reader-text' ).clone(true);
			row.removeClass( 'empty-row screen-reader-text' );
			row.insertBefore( '#repeatable-fieldset-one tbody>tr:last' );
			return false;
		});
  	
		$( '.remove-row' ).on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});
		
		$("tbody.car_features_selector").sortable({
		  cursor: 'row-resize',
		  placeholder: 'ui-state-highlight',
		  opacity: '0.55',
		  items: 'tr'
		}).disableSelection();
		
	});
	</script>

	<h3><?php echo esc_html( 'Car Price', 'novaride-themes-addons' ); ?></h3>	
	<table>
		<tbody>
			<tr valign="top">
				<td>
					<strong><?php echo esc_attr($novaride_currency); ?></strong><input type="text" name="car_price" id="car_price" value="<?php echo $novaride_car_price; ?>">
				</td>
				
				<td>
					<select name="price_type" id="price_type" class="postbox">
						<option value=""><?php echo esc_html( 'Price Type', 'novaride-themes-addons' ); ?></option>
						<option value="Per Day" <?php selected( $price_type, 'Per Day' ); ?>><?php echo esc_html( 'Per Day', 'novaride-themes-addons' ); ?></option>
						<option value="Per Hour" <?php selected( $price_type, 'Per Hour' ); ?>><?php echo esc_html( 'Per Hour', 'novaride-themes-addons' ); ?></option>
					</select>
				</td>
			</tr>
		</tbody>
	</table>
	
	<hr>
	<h3><?php echo esc_html( 'Car Features', 'novaride-themes-addons' ); ?></h3>	
		
	<p>
		<?php printf( 'You can add more features at Car Options > Car Features <a target="_blank" href="%s">Open Setting</a>', esc_url( admin_url( '/customize.php?autofocus[panel]=car_options&autofocus[section]=car_features_section' ) ) ); 
	 ?> 
	</p>
	<table id="repeatable-fieldset-one" width="500">
	<thead>
		<tr>
			<th  width="70%"><?php echo esc_html( 'Select Features', 'novaride-themes-addons' ); ?></th>
			<th width="30%"></th>
		</tr>
	</thead>
	<tbody class="car_features_selector">
	<?php
	
	if ( $novaride_car_features ) :
	
	foreach ( $novaride_car_features as $field ) {
	?>
	<tr class="ui-sortable-handle">
		<td>
			<span class="dashicons dashicons-move"></span>
			<select name="car_features[]">
			<?php foreach ( $options as $label => $value ) : ?>
			<option value="<?php echo $value; ?>"<?php selected( $field['car_features'], $value ); ?>><?php echo $label; ?></option>
			<?php endforeach; ?>
			</select>
			<input type="text" name="car_feature_value[]" id="car_feature_value" value="<?php echo $field['car_feature_value']; ?>">
		</td>

		<td><a class="button remove-row" href="#"><?php echo esc_html( 'Remove', 'novaride-themes-addons' ); ?></a></td>
	</tr>
	<?php
	}
	else :
	// show a blank one
	?>
	<tr class="ui-sortable-handle">
		<td>
			<span class="dashicons dashicons-move"></span>
			<select name="car_features[]">
			<?php foreach ( $options as $label => $value ) : ?>
			<option value="<?php echo $value; ?>"><?php echo $label; ?></option>
			<?php endforeach; ?>
			</select>
			<input type="text" name="car_feature_value[]" id="car_feature_value" value="">
		</td>
	
	
		<td><a class="button remove-row" href="#"><?php echo esc_html( 'Remove', 'novaride-themes-addons' ); ?></a></td>
	</tr>
	<?php endif; ?>
	
	<!-- empty hidden one for jQuery -->
	<tr class="ui-sortable-handle empty-row screen-reader-text">
		<td>
			<span class="dashicons dashicons-move"></span>
			<select name="car_features[]">
			<?php foreach ( $options as $label => $value ) : ?>
			<option value="<?php echo $value; ?>"><?php echo $label; ?></option>
			<?php endforeach; ?>
			</select>
			<input type="text" name="car_feature_value[]" id="car_feature_value" value="">
		</td>
		  
		<td><a class="button remove-row" href="#"><?php echo esc_html( 'Remove', 'novaride-themes-addons' ); ?></a></td>
	</tr>
	</tbody>
	</table>
	
	<p><a id="add-row" class="button" href="#"><?php echo esc_html( 'Add another', 'novaride-themes-addons' ); ?></a></p>
	<?php
}

add_action('save_post', 'novaride_meta_box_save');
function novaride_meta_box_save($post_id) {
	if ( ! isset( $_POST['novaride_meta_box_nonce'] ) ||
	! wp_verify_nonce( $_POST['novaride_meta_box_nonce'], 'novaride_meta_box_nonce' ) )
		return;
	
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
		return;
	
	if (!current_user_can('edit_post', $post_id))
		return;
	

	if ( array_key_exists( 'car_price', $_POST ) ) {
		update_post_meta(
			$post_id,
			'novaride_car_price',
			$_POST['car_price']
		);
	}
	
	if ( array_key_exists( 'price_type', $_POST ) ) {
		update_post_meta(
			$post_id,
			'novaride_car_price_type',
			$_POST['price_type']
		);
	}
	
	$old = get_post_meta($post_id, 'novaride_car_features', true);
	$new = array();
	$options = novaride_car_features_options();
	
	$car_features = $_POST['car_features'];
	$car_feature_value = $_POST['car_feature_value'];
	
	$count = count( $car_features );
	
	for ( $i = 0; $i < $count; $i++ ) {
		if ( $car_features[$i] != '' ) :
			
			if ( in_array( $car_features[$i], $options ) ){
				$new[$i]['car_features'] = $car_features[$i];
				$new[$i]['car_feature_value'] = $car_feature_value[$i];
			}
			else{
				$new[$i]['car_features'] = '';
				$new[$i]['car_feature_value'] = '';
			}
		
			
		endif;
	}

	if ( !empty( $new ) && $new != $old )
		update_post_meta( $post_id, 'novaride_car_features', $new );
	elseif ( empty($new) && $old )
		delete_post_meta( $post_id, 'novaride_car_features', $old );
}
