<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class novaride_initialise_customizer_settings { 
	
	public function __construct() {

		// Register sections
		add_action( 'customize_register', array( $this, 'novaride_register_car_options' ) );
	
	}
	
	/**
	 * Register car option controls
	 */

	public function novaride_register_car_options( $wp_customize ) {   
	
		/**
		 * Load all our Customizer Custom Controls
		 */
		require NOVARIDE_ADDONS_PATH.'includes/customizer/customizer-repeater/inc/customizer-repeater-control.php';
		
		$panel	 				= 'car_options';
		$car_features_section 	= 'car_features_section';
		
		$wp_customize->add_panel( $panel,
		 	array(
				'title' => __( 'Car Options', 'novaride-themes-addons' ),
			)
		);
		
		//Settings section
		$wp_customize->add_section( 'car_settings',
			array(
				'title' => __( 'Settings', 'novaride-themes-addons' ),
				'panel' => $panel
			)
		);
		
		// Currency
		$wp_customize->add_setting( 'novaride_currency', array(
			'default' => '$',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'novaride_currency', array(
			'type' => 'text',
			'section' => 'car_settings',
			'label'       => esc_html__( 'Currency', 'novaride-themes-addons' ),
		) );
		
		// Per Day
		$wp_customize->add_setting( 'novaride_per_day_text', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'novaride_per_day_text', array(
			'type' => 'text',
			'section' => 'car_settings',
			'label'       => esc_html__( 'Per Day label', 'novaride-themes-addons' ),
		) );
		
		// Per Hour
		$wp_customize->add_setting( 'novaride_per_hour_text', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'novaride_per_hour_text', array(
			'type' => 'text',
			'section' => 'car_settings',
			'label'       => esc_html__( 'Per Hour label', 'novaride-themes-addons' ),
		) );
		
		
		
	
		
		
		//End settings section
		
		
		$wp_customize->add_section( $car_features_section,
			array(
				'title' => __( 'Car Features', 'novaride-themes-addons' ),
				'panel' => $panel
			)
		);
		
		$wp_customize->add_setting( 'car_features', array(
			 'sanitize_callback' => 'awaiken_customizer_repeater_sanitize'
		));
		  
		  $wp_customize->add_control( new Awaiken_Customizer_Repeater( $wp_customize, 'car_features', array(
				'label'   => esc_html__('Car Features','novaride-themes-addons'),
				'section' => $car_features_section,
				'priority' => 1,
				'customizer_repeater_image_control' => true,
				'customizer_repeater_icon_control' => true,
				'customizer_repeater_title_control' => true,
				'customizer_repeater_subtitle_control' => false,
				'customizer_repeater_text_control' => false,
				'customizer_repeater_link_control' => false,
				'customizer_repeater_shortcode_control' => false,
				'customizer_repeater_repeater_control' => false
			 ) ) );
			
	}
}


function awaiken_customizer_repeater_sanitize($input){
	$input_decoded = json_decode($input,true);

	if(!empty($input_decoded)) {
		foreach ($input_decoded as $boxk => $box ){
			foreach ($box as $key => $value){

					$input_decoded[$boxk][$key] = wp_kses_post( force_balance_tags( $value ) );

			}
		}
		return json_encode($input_decoded);
	}
	return $input;
}



/**
 * Initialise our Customizer settings
 */
$awaiken_settings = new novaride_initialise_customizer_settings();
