<?php

class CRender {

	private $vobj;
	
	public function __construct($vobj) {
		$this->vobj = $vobj;
	}
	
	private function _setSiteAddiction($seed = "") {
		srand(hexdec(substr(md5(site_url().$seed), -5)));
	}
	
	private function _setTimeAddiction() {
		srand(round(microtime(true) * 1000) + mt_rand(0,10**6));
	}
	
	private function XWPRenderImage() {
		$dir = plugin_dir_path(__FILE__) . 'Render';
		$image = @imagecreatefrompng($dir . "/image/{$this->vobj}.png");
		$width = imagesx($image);
		$height = imagesy($image);
		$scFactor = 1 + (mt_rand(-5, 5) / 100);
		$scWidth = (int)($width * $scFactor);
		$scHeight = (int)($height * $scFactor);
		$resized = imagecreatetruecolor($scWidth, $scHeight);
		imagealphablending($resized, false);
		imagesavealpha($resized, true);
		imagecopyresampled(
			$resized, $image,
			0, 0, 0, 0,
			$scWidth, $scHeight,
			$width, $height
		);
		$crLeft = mt_rand(0, 10);
		$crTop = mt_rand(0, 10);
		$cropRight = mt_rand(0, 10);
		$cropBottom = mt_rand(0, 10);
		$crWidth = $scWidth - $crLeft - $cropRight;
		$crHeight = $scHeight - $crTop - $cropBottom;
		$cropped = imagecreatetruecolor($crWidth, $crHeight);
		imagealphablending($cropped, false);
		imagesavealpha($cropped, true);
		imagecopy(
			$cropped, $resized,
			0, 0, $crLeft, $crTop,
			$crWidth, $crHeight
		);
		ob_start();
		imagepng($cropped);
		$imgData = ob_get_clean();
		imagedestroy($image);
		imagedestroy($resized);
		imagedestroy($cropped);
		return 'data:image/png;base64,' . base64_encode($imgData);
	}

	private function XWPRenderObject($object, $wrap = false) {
		$dir = plugin_dir_path(__FILE__) . 'Render';
		$base = file_get_contents($dir . "/$object.dat");
		$base = explode("\r\n~\r\n", $base);
		$text = "";
		$index = 0;
		foreach($base as $block) {
			$index++;
			$a_blk = explode("\r\n", $block);
			$r_pre = "";
			while($r_pre == "") {
				$r_pre = trim($a_blk[array_rand($a_blk)]);
			}
			$text .= $r_pre . " ";
		}
		if($wrap) {
			$text = str_replace("%WRAP%", $wrap, $text);
		}
		return trim($text);
	}

	public function XWPRenderCategory($cposts) {
		$this->_setSiteAddiction(intval($cposts / XWP_POSTING_CAT));
		return $this->XWPRenderObject("sh_categ_{$this->vobj}");
	}

	public function XWPRenderPTitle() {
		$this->_setTimeAddiction();
		$dir = plugin_dir_path(__FILE__) . 'Render';
		$base = file_get_contents($dir . "/sh_ptitle_{$this->vobj}.dat");
		$base = explode("\r\n", $base);
		$title = "";
		foreach($base as $block) {
			$t_a = explode(",", $block);
			$title .= trim($t_a[array_rand($t_a)]) . " ";
		}
		$title = str_replace("{}", "", $title);
		for($n = 0; $n < 5; $n++) {
			$title = str_replace("  ", " ", $title);
		}
		$title = str_replace("#", $this->vobj, $title);
		return trim($title);
	}

	public function XWPRenderPContent() {
		$this->_setTimeAddiction();
		$content =  $this->XWPRenderObject("/c-{$this->vobj}/1");
		if(mt_rand(0, 1)) {
			$li_block = $this->XWPRenderObject("/c-{$this->vobj}/li");
			$li_block = $this->XWPRenderObject("wr_ulol", $li_block);
			$content .= $li_block;
		}
		$blocks = ["2","3","4","5","6","7","8","9","10","11","12"];
		$block_n = mt_rand(2, 4);
		shuffle($blocks);
		for($n = 0; $n < $block_n; $n++) {
			$content .= $this->XWPRenderObject("/c-{$this->vobj}/" . $blocks[$n]);
		}
		$opt_n = mt_rand(2, 4);
		$optimiz = "";
		for($n = 0; $n < $opt_n; $n++) {
			$optimiz .= $this->XWPRenderObject("sh_optim_{$this->vobj}");
		}
		$optimiz = $this->XWPRenderObject("wr_ulol", $optimiz);
		$content .= $optimiz;
		return $content;
	}

	public function XWPRenderLnkBlock() {
		$this->_setSiteAddiction();
		$dir = plugin_dir_path(__FILE__) . 'Render';
		$dtable = $this->XWPRenderObject("sh_dtable");
		$dbutts = $this->XWPRenderObject("sh_button");
		$this->_setTimeAddiction();
		$sizegb = $this->XWPRenderObject("sh_sizegb");
		$drequm = $this->XWPRenderObject("sh_dreqm_{$this->vobj}");
		$drequm = $this->XWPRenderObject("wr_dreqm_ul", $drequm);
		$block = $sizegb . $dbutts . $drequm;
		$block = $this->XWPRenderObject("wr_dreqm_dv", $block);
		$image = $this->XWPRenderImage();
		$dtable = str_replace("%IMAGE%", $image, $dtable);
		$dtable = str_replace("%BUTTS%", $block, $dtable);
		return $dtable;
	}

	public function XWPRenderDownPage($title) {
		$this->_setSiteAddiction();
		$dir = plugin_dir_path(__FILE__) . 'Render';
		if (!is_dir($dir . "/dpage")) {
			return false;
		}
		$files = glob($dir . '/dpage/*.*');
		if (empty($files)) {
			return false;
		}
		$dpage = $files[array_rand($files)];
		$dhtml = file_get_contents($dpage);
		$dcont = $this->XWPRenderObject("sh_dpage");
		$dcont = $this->XWPRenderObject("wr_dpage", $dcont);
		$block = "[{$this->vobj}]";
		$b_file = $dir . "/$block.html";
		$b_html = file_get_contents($b_file);
		$image = $this->XWPRenderImage();
		$b_html = str_replace("%IMAGE%", $image, $b_html);
		$dhtml = str_replace("%DTITLE%", $title, $dhtml);
		$dhtml = str_replace("%DBLOCK%", $b_html, $dhtml);
		$dhtml = str_replace("%DCONTS%", $dcont, $dhtml);
		return $dhtml;
	}
}

?>