<?php 
/*
Plugin Name:  Novaride Theme Addons
Plugin URI:   https://awaikenthemes.com
Description:  This plugin is intended for use with the novaride theme.
Version:      1.0.0
Author:       Awaiken Technology
Author URI:   https://awaiken.com
License:      GPL2
License URI:  https://www.gnu.org/licenses/gpl-2.0.html
Text Domain:  novaride-themes-addons
Domain Path:  /languages
*/

define( 'NOVARIDE_ADDONS_URL', plugins_url( '/', __FILE__ ) );
define( 'NOVARIDE_ADDONS_PATH', plugin_dir_path( __FILE__ ) );


// Load translation.
add_action( 'init', 'novaride_i18n' );

/**
 * Load the plugin text domain for translation.
 *
 * @since    1.0.0
 */
function novaride_i18n() {
	load_plugin_textdomain( 'novaride-themes-addons' );
}

/* Allow SVG upload */
add_filter( 'wp_check_filetype_and_ext', function( $data, $file, $filename, $mimes ) {

  $filetype = wp_check_filetype( $filename, $mimes );

  return [
      'ext' => $filetype['ext'],
      'type' => $filetype['type'],
      'proper_filename' => $data['proper_filename']
  ];

}, 10, 4 );

function novaride_allow_svg_upload( $mimes ) {
  $mimes['svg'] = 'image/svg+xml';
  $mimes['svgz'] = 'image/svg+xml';
  return $mimes;
}
add_filter( 'upload_mimes', 'novaride_allow_svg_upload' );

require NOVARIDE_ADDONS_PATH . 'includes/secondary-image.php';
require NOVARIDE_ADDONS_PATH . 'includes/customizer.php';
require NOVARIDE_ADDONS_PATH . 'includes/metabox.php';
require NOVARIDE_ADDONS_PATH . 'includes/widgets/widgets.php';

/*
* Portfolio CPT
*/
if(!class_exists('Awaiken_Cpt')) { 
	class Awaiken_Cpt {

		const CPT_SLUG = 'cars';
		const CAR_TYPES_TAXONOMY_SLUG = 'car-types';

		public function register_data() {

			$labels = [
				'name' => esc_html_x( 'Cars', 'Cars', 'novaride-themes-addons' ),
				'singular_name' => esc_html_x( 'Car', 'Car', 'novaride-themes-addons' ),
				'menu_name' => esc_html_x( 'Cars', 'Cars', 'novaride-themes-addons' ),
				'name_admin_bar' => esc_html__( 'Car Item', 'novaride-themes-addons' ),
				'archives' => esc_html__( 'Car Item Archives', 'novaride-themes-addons' ),
				'parent_item_colon' => esc_html__( 'Parent Item:', 'novaride-themes-addons' ),
				'all_items' => esc_html__( 'All Cars', 'novaride-themes-addons' ),
				'add_new_item' => esc_html__( 'Add New Car', 'novaride-themes-addons' ),
				'add_new' => esc_html__( 'Add New Car', 'novaride-themes-addons' ),
				'new_item' => esc_html__( 'New Car', 'novaride-themes-addons' ),
				'edit_item' => esc_html__( 'Edit Car', 'novaride-themes-addons' ),
				'update_item' => esc_html__( 'Update Car', 'novaride-themes-addons' ),
				'view_item' => esc_html__( 'View Car', 'novaride-themes-addons' ),
				'search_items' => esc_html__( 'Search Cars', 'novaride-themes-addons' ),
				'not_found' => esc_html__( 'Not found', 'novaride-themes-addons' ),
				'not_found_in_trash' => esc_html__( 'Not found in Trash', 'novaride-themes-addons' ),
				'featured_image' => esc_html__( 'Featured Image', 'novaride-themes-addons' ),
				'set_featured_image' => esc_html__( 'Set featured image', 'novaride-themes-addons' ),
				'remove_featured_image' => esc_html__( 'Remove featured image', 'novaride-themes-addons' ),
				'use_featured_image' => esc_html__( 'Use as featured image', 'novaride-themes-addons' ),
				'insert_into_item' => esc_html__( 'Insert into Car', 'novaride-themes-addons' ),
				'uploaded_to_this_item' => esc_html__( 'Uploaded to this Car', 'novaride-themes-addons' ),
				'items_list' => esc_html__( 'Items list', 'novaride-themes-addons' ),
				'items_list_navigation' => esc_html__( 'Items list navigation', 'novaride-themes-addons' ),
				'filter_items_list' => esc_html__( 'Filter items list', 'novaride-themes-addons' ),
			];

			$car_slug = apply_filters( 'awaiken_cars_slug', self::CPT_SLUG );

			$rewrite = [
				'slug' => $car_slug,
				'with_front' => false,
			];

			$args = [
				'labels' => $labels,
				'public' => true,
				'menu_position' => 25,
				'menu_icon' => 'dashicons-car',
				'capability_type' => 'post',
				'supports' => [ 'title', 'editor', 'thumbnail', 'author', 'excerpt', 'comments', 'revisions', 'page-attributes', 'custom-fields', 'elementor' ],
				'has_archive' => true,
				'rewrite' => $rewrite,
			];

			register_post_type( self::CPT_SLUG, $args );

			// car type
			$car_type_category_slug = apply_filters( 'awaiken_car_type_slug', 'car-type' );

			$rewrite = [
				'slug' => $car_type_category_slug,
				'with_front' => false,
			];

			$args = [
				'hierarchical' => true,
				'show_ui' => true,
				'show_in_nav_menus' => false,
				'show_admin_column' => true,
				'rewrite' => $rewrite,
				'public' => true,
				'labels' => [
					'name' => esc_html_x( 'Car Types', 'Car', 'novaride-themes-addons' ),
					'singular_name' => esc_html_x( 'Type', 'Car', 'novaride-themes-addons' ),
					'all_items' => esc_html_x( 'All Types', 'Car', 'novaride-themes-addons' ),
				],
			];
			register_taxonomy( self::CAR_TYPES_TAXONOMY_SLUG, self::CPT_SLUG, $args );
			

			
			
		}

		public function __construct() {
			add_action( 'init', [ $this, 'register_data' ], 1 );
		}
	}
	/**
	 * initialize 
	 */
	$Awaiken_Cpt = new Awaiken_Cpt();
}

