<?php 
// Creating the car type list widget
class novaride_list_car_type extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
            "novaride_car_type_list",
            __("Novaride - Car Type List", "novaride-themes-addons"),
			[
                "description" => __(
                    "The widget is used to display a car type list.",
                    "novaride-themes-addons"
                ),
            ]
        );
    }

    // Creating widget front-end

    public function widget($args, $instance)
    {
        $title = apply_filters("widget_title", $instance["title"]);

		echo wp_kses_post( $args["before_widget"] );
		?>
		
		<div class="awaiken-car-types-list">
			<?php if($instance['title']){ ?>
				<h3 class="widget-title"><?php echo sanitize_text_field( $instance['title'] ); ?></h3>
			<?php } ?>
			<?php 
				// We wrap it in unordered list 
				echo '<ul>'; 
					echo wp_list_categories( array('taxonomy' => 'car-types','title_li' => '') );
				echo '</ul>';
			?>
		</div>
		<?php
		echo wp_kses_post( $args["after_widget"] );
    }

    // Widget Backend
    public function form($instance)
    {
		
		/* Set up some default widget settings. */
		$defaults = array( 
			'title' 		 => esc_html__( 'categories', 'novaride-themes-addons' ), 
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		
        ?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'novaride-themes-addons' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo sanitize_text_field( $instance['title'] ); ?>" />
		</p>
		
		<?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance)
    {
        $instance = [];
        $instance["title"] 		= (!empty($new_instance["title"]))? strip_tags($new_instance["title"])  : '';
         return $instance;
    }

    // Class novaride_list_car_type ends here
}

// Register and load the widget
function novaride_load_widget()
{
    register_widget("novaride_list_car_type");
}
add_action("widgets_init", "novaride_load_widget");